package ch.frankel.blog.validation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

import org.junit.Before;
import org.junit.Test;

import ch.frankel.blog.validation.model.inheritance.User;

public class InheritanceValidationTest {

	private Validator validator;

	@Before
	public void setUp() throws Exception {

		validator = Validation.buildDefaultValidatorFactory().getValidator();
	}

	/**
	 * Tests the annotation inheritance. Checks there's a unique violation on
	 * the <code>firstName</code> property.
	 */
	@Test
	public void validateUserNotNull() {

		User user = new User();

		user.setLogin("jo");

		Set<ConstraintViolation<User>> violations = validator.validate(user);

		assertFalse(violations.isEmpty());
		assertEquals(1, violations.size());

		ConstraintViolation<User> violation = violations.iterator().next();

		assertEquals("firstName", violation.getPropertyPath().iterator().next()
				.getName());
	}
}
